/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Intercept all UAs containing  "KDDI"
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: KDDIHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class KDDIHandler extends Handler {

    public KDDIHandler() {
    }

    public KDDIHandler(UserAgentNormalizer normalizer) {
		super(normalizer);
	}

	/**
	 * Checks UA containing "KDDI"
	 */
	public boolean canHandle(String userAgent) {
		return userAgent.indexOf("KDDI") != -1;
	}

}
