/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Intercept all UAs starting with either "kyocera", "QC-" or "KWC-"
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: KyoceraHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class KyoceraHandler extends Handler {

    public KyoceraHandler() {
    }

    public KyoceraHandler(UserAgentNormalizer normalizer) {
		super(normalizer);
	}

	/**
	 * Checks UA starts with either "kyocera", "QC-" or "KWC-"
	 */
	public boolean canHandle(String userAgent) {
		return (userAgent.startsWith("kyocera") || userAgent.startsWith("QC-") || userAgent.startsWith("KWC-"));
	}

}
