/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Intercept all UAs Containing "MSIE" and are not mobile browsers
 *
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: MSIEHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class MSIEHandler extends Handler {

	public MSIEHandler(UserAgentNormalizer normalizer) {
		super(normalizer);
	}

	/**
	 * Checck given UA contains "MSIE" and is not mobile browsers
	 */
	public boolean canHandle(String userAgent) {
        return !isMobileBrowser(userAgent) && userAgent.startsWith("Mozilla") && StringUtils.contains(userAgent,"MSIE");
    }

}
