/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Intercept all UAs starting with "Mot-" or containing "MOT-" or "Motorola".
 *
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: MotorolaHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class MotorolaHandler extends Handler {

    public MotorolaHandler() {
    }

    public MotorolaHandler(UserAgentNormalizer normalizer) {
        super(normalizer);
    }

    /**
     * Intercept all UAs starting with "Mot-", or containing "MOT-" or
     * "Motorola".
     */
    public boolean canHandle(String userAgent) {
        return (userAgent.startsWith("Mot-")
                || StringUtils.contains(userAgent, "MOT-") || StringUtils
                .contains(userAgent, "Motorola"));
    }

}
