/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Intercept all UAs containing "Opera".
 *
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * @version $Id: OperaHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class OperaHandler extends Handler {

    public OperaHandler() {
    }

    public OperaHandler(UserAgentNormalizer normalizer) {
        super(normalizer);
    }

    private static final String OPERA = "Opera";


    /**
     * Checks given UA contains "Opera".
     */
    public boolean canHandle(String userAgent) {
        return !isMobileBrowser(userAgent) && StringUtils.contains(userAgent, OPERA);
    }

}
