/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Intercept all UAs starting with "Pantech","PANTECH","PT-" or "PG-"
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: PantechHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class PantechHandler extends Handler {

    public PantechHandler() {
    }

    public PantechHandler(UserAgentNormalizer normalizer) {
		super(normalizer);
	}

	/**
	 * Checks given UA starts with "Pantech","PANTECH","PT-" or "PG-"
	 */
	public boolean canHandle(String userAgent) {
		return (userAgent.startsWith("Pantech") || userAgent.startsWith("PT-") || userAgent.startsWith("PANTECH") || userAgent
				.startsWith("PG-"));
	}
}
