/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Intercept all UAs starting with either "Philips" or "PHILIPS"
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: PhilipsHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class PhilipsHandler extends Handler {

    public PhilipsHandler() {
    }

    public PhilipsHandler(UserAgentNormalizer normalizer) {
		super(normalizer);
	}

	/**
	 * Checks given UA starts with either "Philips" or "PHILIPS"
	 */
	public boolean canHandle(String userAgent) {
		return (userAgent.startsWith("Philips") || userAgent.startsWith("PHILIPS"));
	}

}
