/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;


/**
 * Intercept all UAs containing "SPV"
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: SPVHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class SPVHandler extends Handler {

    public SPVHandler() {
    }

    public SPVHandler(UserAgentNormalizer normalizer) {
		super(normalizer);
	}

	/**
	 * Check given UA contains "SPV"
	 */
	public boolean canHandle(String userAgent) {
		return StringUtils.contains(userAgent, "SPV");
	}
}
