/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Intercept all UAs containing "Samsung/SGH" or starting with one of the
 * following "SEC-", "Samsung", "SAMSUNG", "SPH", "SGH", "SCH"
 *
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: SamsungHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class SamsungHandler extends Handler {

    public SamsungHandler() {
    }

    public SamsungHandler(UserAgentNormalizer normalizer) {
        super(normalizer);
    }

    /**
     * Checks given UA contains "Samsung/SGH" or starts with one of the
     * following "SEC-", "Samsung", "SAMSUNG", "SPH", "SGH", "SCH"
     */
    public boolean canHandle(String userAgent) {

        return (StringUtils.contains(userAgent, "Samsung/SGH")
                || userAgent.startsWith("SEC-")
                || userAgent.contains("Samsung")
                || userAgent.startsWith("SAMSUNG")
                || userAgent.startsWith("SPH") || userAgent.startsWith("SGH") || userAgent
                .startsWith("SCH"));
    }
}
