/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Intercept all UAs starting with "Mozilla/" and containing "Windows CE"
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WindowsCEHandler.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class WindowsCEHandler extends Handler {

    public WindowsCEHandler() {
    }

    public WindowsCEHandler(UserAgentNormalizer normalizer) {
		super(normalizer);
	}

	/**
	 * Checks given UA contains "Mozilla/" and "Windows CE"
	 */
	public boolean canHandle(String userAgent) {
		return StringUtils.contains(userAgent, "Mozilla/")
                && (StringUtils.contains(userAgent, "Windows CE")
                || StringUtils.contains(userAgent, "WindowsCE"));
	}
}
