/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.classifiers;


/**
 * Filter interface.
 * <p>
 * This is responsible to classify devices based to user-agent.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: Filter.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface Filter {

	/**
	 * It returns if this class can classify the given user-agent.
	 * 
	 * @param userAgent
	 *            The user-agent to probr.
	 * @return True if this classifier can handle <code>userAgent</code>.
	 */
	boolean canHandle(String userAgent);

	/**
	 * Classify the given deviceId with corresponding user-agent.
	 * 
	 * @param userAgent
	 *            The user-agent to classify.
	 * @param deviceID
	 *            The device identifier corresponding to given user-agent.
	 */
	void filter(String userAgent, String deviceID);
	
	/**
	 * Returns collected {@link FilteredDevices}.
	 */
	FilteredDevices getFilteredDevices();

}
