/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.classifiers;

import java.util.Iterator;
import java.util.Map;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.HandlersFactory;

/**
 * Factory used to build {@link FilterChain}.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: FilterChainFactory.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class FilterChainFactory {

	/** Held FilterChain */
	private FilterChain chain = new FilterChain();

	/**
	 * Build FilterChainFactory by HandlersFactory
	 * 
	 * @param handlersFactory
	 *            The HandlersFactory used to obtain handlers.
	 */
	public FilterChainFactory(HandlersFactory handlersFactory) {
		this(handlersFactory.create());
	}

	/**
	 * Build FiltersChainFactory by handlers Map.
	 * 
	 * @param handlers
	 *            Map containig handlers and relative key.
	 */
	public FilterChainFactory(Map handlers) {
		init(handlers);
	}

	/**
	 * Build the filters by handlers map.
	 * 
	 * @param handlers
	 *            Map containig handlers and relative key.
	 */
	private void init(Map handlers) {
		for (Iterator iterator = handlers.entrySet().iterator(); iterator
				.hasNext();) {
			Map.Entry entry = (Map.Entry) iterator.next();
			Handler handler = (Handler) entry.getValue();
			chain.add(new BaseFilter(handler));
		}
	}

	/**
	 * Return held FilterChain instance.
	 * 
	 * @return FilterChain build by this factory.
	 */
	public FilterChain create() {
		return chain;
	}

}
