/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: AndroidMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 * 
 */
public class AndroidMatcher extends AbstractMatcher  {

    private static final String GENERIC_ANDROID = "generic_android";

    
    public AndroidMatcher(Handler handler) {
		super(handler);
	}
	
	protected String lookForMatchingUserAgent(SortedSet userAgentsSet,
			String userAgent) {
		int tolerance = StringUtils.indexOfOrLength(userAgent, " ", StringUtils.indexOfOrLength(userAgent, "Android"));
		return StringUtils.risMatch(userAgentsSet, userAgent, tolerance);
	}

    protected String applyRecoveryMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        return GENERIC_ANDROID;
    }
}
