/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.request.WURFLRequest;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * @version $Id: AppleMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class AppleMatcher extends AbstractMatcher {


    public AppleMatcher(Handler handler) {
        super(handler);
    }

    /**
     * Apply RIS(First Semicolon).
     */
    protected String lookForMatchingUserAgent(SortedSet userAgentsSet,
                                              String userAgent) {
        int tolerance = net.sourceforge.wurfl.core.utils.StringUtils.firstSemiColon(userAgent);

        if (logger.isDebugEnabled()) {
            logger.debug("Applying RIS(First Semicolon) UA: " + userAgent);
        }

        return net.sourceforge.wurfl.core.utils.StringUtils.risMatch(userAgentsSet, userAgent, tolerance);

    }

    private static final String IPOD = "iPod";
    private static final String IPAD = "iPad";

    protected String applyRecoveryMatch(WURFLRequest request, FilteredDevices filteredDevices) {

        final String userAgent = request.getUserAgent();
        if (StringUtils.contains(userAgent, IPAD)) {
            return "apple_ipad_ver1";
        }

        if (StringUtils.contains(userAgent, IPOD)) {
            return "apple_ipod_ver1";
        }
        
        return "apple_iphone_ver1";

    }
}
