/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

import net.sourceforge.wurfl.core.Constants;
import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.utils.Predicates;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * @version $Id: BlackBerryMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class BlackBerryMatcher extends AbstractMatcher {

    public BlackBerryMatcher(Handler handler) {
        super(handler);
    }

    /**
     * Parse version number ("2","3.2","3.3","3.5","3.6","3.7","4.") and return
     * "blackberry_generic_ver2","blackberry_generic_ver3_sub2",
     * "blackberry_generic_ver3_sub30", "blackberry_generic_ver3_sub50",
     * "blackberry_generic_ver3_sub60","blackberry_generic_ver3_sub70" or
     * "blackberry_generic_ver4" respectively
     */
    private static final Map blackberries = new HashMap();

    static {
        blackberries.put("2.", "blackberry_generic_ver2");
        blackberries.put("3.2", "blackberry_generic_ver3_sub2");
        blackberries.put("3.3", "blackberry_generic_ver3_sub30");
        blackberries.put("3.5", "blackberry_generic_ver3_sub50");
        blackberries.put("3.6", "blackberry_generic_ver3_sub60");
        blackberries.put("3.7", "blackberry_generic_ver3_sub70");
        blackberries.put("4.", "blackberry_generic_ver4");
    }

    protected String applyRecoveryMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        String userAgent = request.getUserAgent();
        String version = version(userAgent);
        String key = (String) CollectionUtils.find(blackberries.keySet(), Predicates.isContainedIn(version));
        if (key != null) {
            return (String) blackberries.get(key);
        }

        return Constants.GENERIC;


    }

    private String version(String userAgent) {
        int position = userAgent.indexOf('/');
        String version = null;
        if (position != -1 && position + 4 <= userAgent.length()) {
            version = userAgent.substring(position + 1, position + 4);
        }
        return version;
    }

}
