/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * This is a matcher for BOTs
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $id$
 */
public class BotMatcher extends AbstractMatcher {

    private static final int BOT_TOLERANCE = 4;
    private static final String GENERIC_WEB_CRAWLER = "generic_web_crawler";

    public BotMatcher(Handler handler) {
        super(handler);
    }

    protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {
        return StringUtils.ldMatch(userAgentsSet, userAgent, BOT_TOLERANCE);
    }

    protected String applyRecoveryMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        return GENERIC_WEB_CRAWLER;
    }
}
