/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.request.WURFLRequest;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * @version $Id: DoCoMoMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class DoCoMoMatcher extends AbstractMatcher {

    public DoCoMoMatcher(Handler handler) {
        super(handler);
    }

    /**
     * Does not perform anything. It returns always null. DoCoMo are direct match
     * only.
     */
    protected String lookForMatchingUserAgent(SortedSet userAgentsSet,
                                              String userAgent) {

        // docomo is direct match only
        return null;
    }

    protected String applyRecoveryMatch(WURFLRequest request,
                                        FilteredDevices filteredDevices) {
        if (request.getUserAgent().startsWith("DoCoMo/2")) {
            return "docomo_generic_jap_ver2";
        }
        return "docomo_generic_jap_ver1";
    }

}
