/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * @version $Id: KDDIMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class KDDIMatcher extends AbstractMatcher {

    public KDDIMatcher(Handler handler) {
        super(handler);
    }

    /**
     * 
     */
    protected String lookForMatchingUserAgent(SortedSet userAgentsSet,
                                              String userAgent) {

        int tolerance = tolerance(userAgent);
        if (logger.isDebugEnabled()) {
            logger.debug("Applying RIS with tolerance[" + tolerance + "] UA: " + userAgent);
        }

        return StringUtils.risMatch(userAgentsSet, userAgent, tolerance);
    }

    private int tolerance(String userAgent) {
        if (userAgent.startsWith("KDDI/")) {
            return StringUtils.secondSlash(userAgent);
        }
        if (userAgent.startsWith("KDDI")) {
            return StringUtils.firstSlash(userAgent);
        }

        return StringUtils.indexOfOrLength(userAgent, ")");
    }

    protected String applyRecoveryMatch(WURFLRequest request,
                                        FilteredDevices filteredDevices) {
        if (request.getUserAgent().indexOf("Opera") != -1) {
            return "opera";
        }
        return "opwv_v62_generic";
    }
}
