/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: LGMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class LGMatcher extends AbstractMatcher {

	public LGMatcher(Handler handler) {
		super(handler);
	}

	protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {
        int tolerance = userAgent.length();
        if(userAgent.indexOf("Vodafone") != -1 ) {
            tolerance = StringUtils.ordinalIndexOfOrLength(userAgent, "LG", 1);    
        } else if (userAgent.startsWith("LGE/") || userAgent.startsWith("LG/")) {
			tolerance = StringUtils.secondSlash(userAgent);
		} else {
            tolerance = StringUtils.firstSlash(userAgent);
        }

        if (logger.isDebugEnabled()) {
				logger.debug("Applying RIS(SS) UA: " + userAgent);
			}
        return StringUtils.risMatch(userAgentsSet, userAgent, tolerance);

	}

}
