/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.request.WURFLRequest;

/**
 * A user-agent matcher.
 * 
 * <p>
 * The user-agent matchers classes must implement this interface.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: Matcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface Matcher {

	/**
	 * Return if this matcher can handle given request.
	 * 
	 * @param request
	 *            The {@link WURFLRequest} to check if can be handled.
	 * @return True if this matcher can handle given request.
	 */
	boolean canHandle(WURFLRequest request);

	/**
	 * Perform matching. It never returns null, at least it returns
	 * <code>generic</code> device.
	 * 
	 * @param request
	 *            The request to match.
	 * @return Return the matched device identifier.
	 */
	String match(WURFLRequest request, FilteredDevices filteredDevices);

}
