/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.Map;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.HandlerConstants;
import net.sourceforge.wurfl.core.handlers.HandlersFactory;

/**
 * Factory class for matchers chain.
 * <p>
 * This class build a {@link MatcherChain} with given {@link net.sourceforge.wurfl.core.handlers.HandlersFactory}
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: MatcherChainFactory.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class MatcherChainFactory {

	private final MatcherChain chain = new MatcherChain();

	public MatcherChainFactory(HandlersFactory handlersFactory) {
		this(handlersFactory.create());
	}
	
	public MatcherChainFactory(Map handlers) {
		init(handlers);
	}

	private void init(Map handlers) {
		chain.add(new NokiaMatcher((Handler) handlers
				.get(HandlerConstants.NOKIA)));

        chain.add(new AndroidMatcher((Handler) handlers.get(HandlerConstants.ANDROID)));
        
		chain.add(new SonyEricssonMatcher((Handler) handlers
				.get(HandlerConstants.SONY_ERICSSON)));
		chain.add(new MotorolaMatcher((Handler) handlers
				.get(HandlerConstants.MOTOROLA)));
		chain.add(new BlackBerryMatcher((Handler) handlers
				.get(HandlerConstants.BLACKBERRY)));
		chain.add(new SiemensMatcher((Handler) handlers
				.get(HandlerConstants.SIEMENS)));
		chain.add(new SagemMatcher((Handler) handlers
				.get(HandlerConstants.SAGEM)));
		chain.add(new SamsungMatcher((Handler) handlers
				.get(HandlerConstants.SAMSUNG)));
		chain.add(new PanasonicMatcher((Handler) handlers
				.get(HandlerConstants.PANASONIC)));
		chain.add(new NecMatcher((Handler) handlers.get(HandlerConstants.NEC)));
		chain
				.add(new QtekMatcher((Handler) handlers
						.get(HandlerConstants.QTEK)));
		chain.add(new MitsubishiMatcher((Handler) handlers
				.get(HandlerConstants.MITSUBISHI)));
		chain.add(new PhilipsMatcher((Handler) handlers
				.get(HandlerConstants.PHILIPS)));
		chain.add(new LGMatcher((Handler) handlers.get(HandlerConstants.LG)));
		chain.add(new AppleMatcher((Handler) handlers
				.get(HandlerConstants.APPLE)));
		chain.add(new KyoceraMatcher((Handler) handlers
				.get(HandlerConstants.KYOCERA)));
		chain.add(new AlcatelMatcher((Handler) handlers
				.get(HandlerConstants.ALCATEL)));
		chain.add(new SharpMatcher((Handler) handlers
				.get(HandlerConstants.SHARP)));
		chain.add(new SanyoMatcher((Handler) handlers
				.get(HandlerConstants.SANYO)));
		chain
				.add(new BenQMatcher((Handler) handlers
						.get(HandlerConstants.BENQ)));
		chain.add(new PantechMatcher((Handler) handlers
				.get(HandlerConstants.PANTECH)));
		chain.add(new ToshibaMatcher((Handler) handlers
				.get(HandlerConstants.TOSHIBA)));
		chain.add(new GrundigMatcher((Handler) handlers
				.get(HandlerConstants.GRUNDIG)));
		chain.add(new HTCMatcher((Handler) handlers.get(HandlerConstants.HTC)));

        chain.add(new BotMatcher((Handler) handlers.get(HandlerConstants.BOT)));
        
		chain.add(new SPVMatcher((Handler) handlers.get(HandlerConstants.SPV)));
		chain.add(new WindowsCEMatcher((Handler) handlers
				.get(HandlerConstants.WINDOWS_CE)));
		chain.add(new PortalmmmMatcher((Handler) handlers
				.get(HandlerConstants.PORTALMMM)));
		chain.add(new DoCoMoMatcher((Handler) handlers
				.get(HandlerConstants.DOCOMO)));
		chain.add(new KDDIMatcher((Handler) handlers
				.get(HandlerConstants.KDDDI)));

        chain.add(new VodafoneMatcher((Handler) handlers
                .get(HandlerConstants.VODAFONE)));
        

		chain.add(new OperaMiniMatcher((Handler) handlers.get(HandlerConstants.OPERA_MINI)));
		
		chain.add(new ChromeMatcher((Handler) handlers.get(HandlerConstants.CHROME)));
		chain.add(new AOLMatcher((Handler)handlers.get(HandlerConstants.AOL)));
		chain.add(new OperaMatcher((Handler)handlers.get(HandlerConstants.OPERA)));
		chain.add(new KonquerorMatcher((Handler) handlers.get(HandlerConstants.KONQUEROR)));
		chain.add(new FirefoxMatcher((Handler)handlers.get(HandlerConstants.FIREFOX)));
		chain.add(new SafariMatcher((Handler)handlers.get(HandlerConstants.SAFARI)));
		chain.add(new MSIEMatcher((Handler)handlers.get(HandlerConstants.MSIE)));
		
		chain.add(new CatchAllMatcher((Handler) handlers
				.get(HandlerConstants.CATCH_ALL)));
	}

	public MatcherChain create() {
		return chain;
	}
}
