/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import net.sourceforge.wurfl.core.Constants;
import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * @version $Id: MotorolaMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class MotorolaMatcher extends AbstractMatcher {

    private static final int MOTOROLA_TOLLERANCE = 5;

    public MotorolaMatcher(Handler handler) {
        super(handler);
    }

    /**
     * If UA don't starts with "Mot-","MOT-" or "Motorola" then apply LD(5)
     * otherwise apply default.
     */
    protected String lookForMatchingUserAgent(SortedSet userAgentsSet,
                                              String userAgent) {
        if (userAgent.startsWith("Mot-") || userAgent.startsWith("MOT-")
                || userAgent.startsWith("Motorola")) {
            return super.lookForMatchingUserAgent(userAgentsSet, userAgent);
        }

        return StringUtils.ldMatch(userAgentsSet, userAgent,
                MOTOROLA_TOLLERANCE);
    }

    /**
     * if UA contains "MIB/2.2" or "MIB/BER2.2", return "mot_mib22_generic"
     * otherwise return "generic".
     */
    protected String applyCatchAllRecoveryMatch(WURFLRequest request,
                                                FilteredDevices filteredDevices) {
        String userAgent = request.getUserAgent();
        if ((userAgent.indexOf("MIB/2.2") != -1)
                || (userAgent.indexOf("MIB/BER2.2") != -1)) {
            return "mot_mib22_generic";
        }

        return Constants.GENERIC;
    }

}
