/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: NecMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class NecMatcher extends AbstractMatcher {
	
	private static final int NEC_LD_TOLLERANCE = 2;

	public NecMatcher(Handler handler) {
		super(handler);
	}

	/**
	 * If UA starts with "NEC", apply default, else apply LD(2).
	 */
	protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {

		if (userAgent.startsWith("NEC")) {
			return super.lookForMatchingUserAgent(userAgentsSet, userAgent);
		}

		if (logger.isDebugEnabled()) {
			logger.debug("Applying LD(" + NEC_LD_TOLLERANCE + " UA: " + userAgent);
		}
		
		return StringUtils.ldMatch(userAgentsSet, userAgent, NEC_LD_TOLLERANCE);

	}

}
