/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.Constants;
import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.request.WURFLRequest;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: NokiaMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class NokiaMatcher extends AbstractMatcher {
	
	public NokiaMatcher(Handler handler) {
		super(handler);
	}

	/**
	 * Apply RIS with FS (First Slash) after Nokia String as a threshold.
	 */
	protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {
		
		int tollerance = net.sourceforge.wurfl.core.utils.StringUtils.indexOfOrLength(userAgent, "/", userAgent.indexOf("Nokia"));
		String match = net.sourceforge.wurfl.core.utils.StringUtils.risMatch(userAgentsSet, userAgent, tollerance);

		return match;
	}

	/**
	 * Search for "Series60" and "Series80". Return "nokia_generic_series60" and
	 * "nokia_generic_series80" respectively in case of success
	 * 
	 */
	protected String applyRecoveryMatch(WURFLRequest request,
			FilteredDevices filteredDevices) {

		String userAgent = request.getUserAgent();

		if (logger.isDebugEnabled()) {
			logger.debug("Applying Nokia Recovery Match on User-Agent: "
					+ userAgent);
		}

		if (StringUtils.contains(userAgent, "Series60")) {
			return "nokia_generic_series60";
		}
		if (StringUtils.contains(userAgent, "Series80")) {
			return "nokia_generic_series80";
		}
		return Constants.GENERIC;

	}

}
