/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.*;
import java.util.regex.Matcher;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * @version $Id: OperaMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class OperaMatcher extends AbstractMatcher {

    private static final int OPERA_TOLERANCE = 3;

    public OperaMatcher(Handler handler) {
        super(handler);
    }

    /**
     *
     */
    protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {
        return StringUtils.ldMatch(userAgentsSet, userAgent, OPERA_TOLERANCE);
    }

    private static final Map operas = new HashMap();
    static {
        operas.put("", "opera");
        operas.put("7", "opera_7");
        operas.put("8", "opera_8");
        operas.put("9", "opera_9");
        operas.put("10", "opera_10");
    }

    protected String applyRecoveryMatch(WURFLRequest request, FilteredDevices filteredDevices) {
        String operaVersion = operaVersion(request.getUserAgent());
        String id = (String) operas.get(operaVersion);
        if (id == null) {
            id = "opera";
        }
        return id;
    }

    public static final Pattern OPERA_VERSION_PATTERN = Pattern.compile(".*Opera/(\\d+).*");

    private String operaVersion(String userAgent) {
        final Matcher matcher = OPERA_VERSION_PATTERN.matcher(userAgent);
        return matcher.matches() ? matcher.group(1) : "";
    }
}
