/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.request.WURFLRequest;

/**
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: OperaMiniMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class OperaMiniMatcher extends AbstractMatcher {


	public OperaMiniMatcher(Handler handler) {
		super(handler);
	}
	
	protected String applyRecoveryMatch(WURFLRequest request,
			FilteredDevices filteredDevices) {
		
		String match = null;
		
		if (StringUtils.contains(request.getUserAgent(), "Opera Mini/1")) {
			match = "opera_mini_ver1";
		}
		else if (StringUtils.contains(request.getUserAgent(), "Opera Mini/2")) {
			match = "opera_mini_ver2";
		}
		else if (StringUtils.contains(request.getUserAgent(), "Opera Mini/3")) {
			match = "opera_mini_ver3";
		}
		else if (StringUtils.contains(request.getUserAgent(), "Opera Mini/4")) {
			match = "opera_mini_ver4";
		}
		
		return match;
		
	}

}
