/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: PantechMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class PantechMatcher extends AbstractMatcher {
	
	private static final int PANTECH_LD_TOLLERANCE = 4;

	public PantechMatcher(Handler handler) {
		super(handler);
	}

	/**
	 * If starts with "Pantech" applies LD(4) otherwise default.
	 */
	protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {

		if (userAgent.startsWith("Pantech")) {
			
			if (logger.isDebugEnabled()) {
				logger.debug("Applying LD(" + PANTECH_LD_TOLLERANCE + ") UA: " + userAgent);
			}
			
			return StringUtils.ldMatch(userAgentsSet, userAgent, PANTECH_LD_TOLLERANCE);
		}
		else {

			return super.lookForMatchingUserAgent(userAgentsSet, userAgent);
		}
	}

}
