/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import org.apache.commons.lang.text.StrBuilder;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.matchers.strategy.RISMatcher;
import net.sourceforge.wurfl.core.handlers.matchers.strategy.StringMatcher;
import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * This UserAgentHandler handles the SPV devices.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: SPVMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class SPVMatcher extends AbstractMatcher {

	public SPVMatcher(Handler handler) {
		super(handler);
	}

	/**
	 * <p>
	 * Apply RIS after first ; on SPV  
	 * </p>
	 */
	protected String lookForMatchingUserAgent(SortedSet userAgentsSet,
			String userAgent) {

		
		// Default values
		StringMatcher matcher = RISMatcher.INSTANCE;
		int tollerance = StringUtils.indexOfOrLength(userAgent, ";", StringUtils.indexOfOrLength(userAgent, "SPV"));
		
		if(logger.isDebugEnabled()){
			
			StrBuilder logBuilder = new StrBuilder();
			logBuilder.append("Applying ");
			
			logBuilder.append(matcher);
			logBuilder.append(tollerance).append(") UA: ");
			logBuilder.append(userAgent);
		}

		return matcher.match(userAgentsSet, userAgent, tollerance);
	}

}
