/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.Constants;
import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.handlers.classifiers.FilteredDevices;
import net.sourceforge.wurfl.core.request.WURFLRequest;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: SafariMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class SafariMatcher extends AbstractMatcher {

	
	public SafariMatcher(Handler handler) {
		super(handler);
	}


	protected String applyRecoveryMatch(WURFLRequest request,
			FilteredDevices filteredDevices) {
		
		String userAgent = request.getUserAgent();
		
		if(StringUtils.contains(userAgent, "Macintosh") || StringUtils.contains(userAgent, "Windows")){
			return Constants.GENERIC_WEB_BROWSER;
		}
		else {
			return Constants.GENERIC;
		}
		
	}

}
