/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * @version $Id: SamsungMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class SamsungMatcher extends AbstractMatcher {

    public SamsungMatcher(Handler handler) {
        super(handler);
    }

    /**
     * <p>
     * If UA starts with one of the following ("SEC-", "SAMSUNG-", "SCH"), apply
     * default.
     * </p>
     * <p>
     * Else if UA starts with one of the following ("Samsung-","SPH", "SGH" ), apply RIS(FP).
     * </p>
     * <p>
     * Else if UA starts with "SAMSUNG/", apply RIS(SS).
     * </p>
     */
    protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {

        int tolerance = tolerance(userAgent);
        if (logger.isDebugEnabled()) {
            logger.debug("Applying RIS with Tolerance[" + tolerance + "] on UA: " + userAgent);
        }
        return StringUtils.risMatch(userAgentsSet, userAgent, tolerance);

    }

    private int tolerance(String userAgent) {
        if (userAgent.startsWith("SEC-") || userAgent.startsWith("SAMSUNG-") || userAgent.startsWith("SCH")) {
            return StringUtils.firstSlash(userAgent);
        }
        if (userAgent.startsWith("Samsung") || userAgent.startsWith("SPH") || userAgent.startsWith("SGH")) {
            return StringUtils.firstSpace(userAgent);
        }
        if (userAgent.startsWith("SAMSUNG/")) {
            return StringUtils.secondSlash(userAgent);
        }
        if (org.apache.commons.lang.StringUtils.contains(userAgent, "Samsung/SGH-L870")) {
            return StringUtils.ordinalIndexOfOrLength(userAgent, "/", 5);
        }

        return userAgent.length();
    }

}
