/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: SonyEricssonMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class SonyEricssonMatcher extends AbstractMatcher {

	public SonyEricssonMatcher(Handler handler) {
		super(handler);
	}

	/**
	 * If UA starts with "SonyEricsson", apply RIS with FS as a threshold. If UA
	 * contains "SonyEricsson" somewhere in the middle, apply RIS with threshold
	 * second slash
	 */
	protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {
		if (userAgent.startsWith("SonyEricsson")) {
			return super.lookForMatchingUserAgent(userAgentsSet, userAgent);
		}

		int tollerance = StringUtils.secondSlash(userAgent);

		if (logger.isDebugEnabled()) {
			logger.debug("Appling RIS(SS) UA: " + userAgent);
		}

		return StringUtils.risMatch(userAgentsSet, userAgent, tollerance);

	}

}
