/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import org.apache.commons.lang.text.StrBuilder;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: VodafoneMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class VodafoneMatcher extends AbstractMatcher {

    public VodafoneMatcher(Handler handler) {
        super(handler);
    }

    protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {

        int tolerance = StringUtils.ordinalIndexOfOrLength(userAgent, "/", 3);
        log(userAgent,tolerance);

        return StringUtils.risMatch(userAgentsSet, userAgent, tolerance);

    }

    private void log(String userAgent, int tolerance) {
        if (logger.isDebugEnabled()) {

            StrBuilder logBuilder = new StrBuilder();
            logBuilder.append("Applying RIS: ");
            logBuilder.append(tolerance).append(") UA: ");
            logBuilder.append(userAgent);
            logger.debug(logBuilder.toString());
        }
    }


}
