/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers;

import java.util.SortedSet;

import net.sourceforge.wurfl.core.handlers.Handler;
import net.sourceforge.wurfl.core.request.WURFLRequest;
import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WindowsCEMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class WindowsCEMatcher extends AbstractMatcher {
	
	private static final int WINDOWS_CE_TOLLERANCE = 3;

	public WindowsCEMatcher(Handler handler) {
		super(handler);
	}

	/**
	 * Apply LD(3).
	 */
	protected String lookForMatchingUserAgent(SortedSet userAgentsSet, String userAgent) {

		if (logger.isDebugEnabled()) {
			logger.debug("Applying LD(" + WINDOWS_CE_TOLLERANCE + ") UA: " + userAgent);
		}

		return StringUtils.ldMatch(userAgentsSet, userAgent, WINDOWS_CE_TOLLERANCE);
	}

	/**
	 * return "ms_mobile_browser_ver1"
	 */
	public String applyRecoveryMatch(WURFLRequest request) {
		return "ms_mobile_browser_ver1";
	}

}
