/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.handlers.matchers.strategy;

import java.util.SortedSet;

/**
 * Match a string in a ordered set of string, returning the best match.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: StringMatcher.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface StringMatcher {

	/**
	 * Match the given user-agent to the user-agent map to obtain device id.
	 * 
	 * @param userAgentsSet
	 *            Had to containing the user-agent string naturally ordered.
	 * @param needle
	 *            The user-agent to match.
	 * @param tollerance
	 *            The tolerance accepted for the matching.
	 * @return The device id matched by the given user-agent.
	 */
	String match(SortedSet userAgentsSet, String needle, int tollerance);
}
