/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;
import net.sourceforge.wurfl.core.request.normalizer.generic.BabelFishNormalizer;
import net.sourceforge.wurfl.core.request.normalizer.generic.BlackBerryNormalizer;
import net.sourceforge.wurfl.core.request.normalizer.generic.UPLinkNormalizer;
import net.sourceforge.wurfl.core.request.normalizer.generic.VodafoneNormalizer;
import net.sourceforge.wurfl.core.request.normalizer.generic.YesWAPNormalizer;

/**
 * UserAgentNormalizerFactory default implementation.
 * 
 * <p>
 * Build a UserAgentNormalizerChain with the WURFL UserAgentNormalizers.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: DefaultUserAgentNormalizerFactory.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class DefaultUserAgentNormalizerFactory implements UserAgentNormalizerFactory {

	/** Log */
	private static final Log LOG = LogFactory.getLog(DefaultUserAgentNormalizerFactory.class);

	/**
	 * {@inheritDoc}
	 * 
	 * @return UserAgentNormalizerChain
	 */
	public UserAgentNormalizer create() {
		
		LOG.debug("Creating UserAgentNormalizerChain...");

		UserAgentNormalizerChain chain = new UserAgentNormalizerChain();
		chain.add(new VodafoneNormalizer());
		chain.add(new BlackBerryNormalizer());
		chain.add(new UPLinkNormalizer());
		chain.add(new YesWAPNormalizer());
		chain.add(new BabelFishNormalizer());
		
		return chain;
	}

}
