/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.Validate;

/**
 * {@link UserAgentResolver} default implementation.
 * <p>
 * The default implementation of UserAgentResolver gets user-agent from:
 * <ul>
 * <li>UA request parameter.</li>
 * <li>x-device-user-agent request header.</li>
 * <li>User-Agent request header.</li>
 * </ul>
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: DefaultUserAgentResolver.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class DefaultUserAgentResolver implements UserAgentResolver {

	public DefaultUserAgentResolver() {
		// Empty
	}
	
	/**
	 * {@inheritDoc}
	 */
	public String resolve(HttpServletRequest request) {

		Validate.notNull(request, "The HttpServletRequest is null");

		String userAgent = null;
		
		/*
		 * Catch headers names from the more specific to less.
		 */
		
		// Catch Request Parameter
		if (request.getParameter("UA") != null) {
			userAgent = request.getParameter("UA");
		}
		
		// Catch several known Transcoder/Proxy and similars.
		// TODO Move this logic to Matcher in future version.
		else if(request.getHeader("X-Skyfire-Version") != null){
			userAgent = "Generic_Skyfire_Browser";
		} 
		else if (request.getHeader("x-device-user-agent") != null) {
			userAgent = request.getHeader("x-device-user-agent");
		} 
		
		// Catch standard user-agent
		else {
			userAgent = request.getHeader("User-Agent");
		}

		return userAgent;
	}

}
