/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * {@link WURFLRequest} default implementation.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: DefaultWURFLRequest.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class DefaultWURFLRequest implements WURFLRequest, Serializable {

	/** Serial */
	private static final long serialVersionUID = 100L;

	/** user-agent */
	private String userAgent;

	/** UAProf */
	private String userAgentProfile;


	// Constructors *******************************************************

	/**
	 * Constructor by user-agent, UAProf, and xhtml support
	 * 
	 * @param userAgent
	 *            The requester device user-agent.
	 * @param userAgentProfile
	 *            The UAProf URL
	 * @param xhtmlDevice
	 *            True if the requester support xhtml markup.
	 */
	public DefaultWURFLRequest(String userAgent, String userAgentProfile) {
		this.userAgent = userAgent;
		this.userAgentProfile = userAgentProfile;
	}

	// Access methods *****************************************************

	/**
	 * Return the requester user-agent.
	 * 
	 * @return A string containing requester user-agent.
	 */
	public String getUserAgent() {
		return userAgent;
	}

	/**
	 * Return the requester UAProf URL.
	 * 
	 * @return A string containig URL of requester UAProf.
	 */
	public String getUserAgentProfile() {
		return userAgentProfile;
	}

	// Commons methods ****************************************************

	public int hashCode() {
		HashCodeBuilder hb = new HashCodeBuilder(35, 79);

		// TODO cache hashcode to transient member
		hb.append(getClass()).append(userAgent).append(userAgentProfile).toHashCode();

		return hb.toHashCode();
	}

	public boolean equals(Object other) {
		EqualsBuilder eb = new EqualsBuilder();

		eb.appendSuper(getClass().isInstance(other));

		if (eb.isEquals()) {
			DefaultWURFLRequest otherRequest = (DefaultWURFLRequest) other;
			eb.append(userAgent, otherRequest.userAgent);
			eb.append(userAgentProfile, otherRequest.userAgentProfile);
		}

		return eb.isEquals();
	}

	public String toString() {
		ToStringBuilder tb = new ToStringBuilder(this);

		tb.append(userAgent).append(userAgentProfile).toString();

		return tb.toString();
	}
}
