/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request;

import javax.servlet.http.HttpServletRequest;

/**
 * This class is intended to supply a fast way to resolve user-agent from the
 * given HTTP request. It is not a good choice to production environment, USE IT
 * ONLY FOR TESTING.
 * 
 * @author Filippo De Luca
 * @version $Id: FastUserAgentResolver.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public final class FastUserAgentResolver implements UserAgentResolver {

	public FastUserAgentResolver() {
		// Empty
	}

	public String resolve(HttpServletRequest request) {
		return request.getHeader("User-Agent");
	}

}
