/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Factory for {@link UserAgentNormalizer}.
 * 
 * <p>
 * The factories for UserAgentNormalizer must implement this interface.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: UserAgentNormalizerFactory.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface UserAgentNormalizerFactory {

	/**
	 * Create the UserAgentNormalizer.
	 * 
	 * @return The builded UserAgentNormalizer.
	 */
	UserAgentNormalizer create();
}
