/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request;

import javax.servlet.http.HttpServletRequest;

/**
 * User-Agent resolver.
 * <p>
 * Interface used to retrieve user-agent header from HTTP request.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: UserAgentResolver.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface UserAgentResolver {

	/**
	 * Resolve User-Agent header from HTTP request.
	 * 
	 * @param request
	 *            The HTTP request
	 * @return String contains user-agent the request come from.
	 */
	String resolve(HttpServletRequest request);

}
