/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request;

/**
 * Factory of {@link UserAgentResolver}
 * <p>
 * Build instances of {@link UserAgentResolver}
 * </p>
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: UserAgentResolverFactory.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface UserAgentResolverFactory {
	
	/**
	 * Build UserAgentResolver instance.
	 * 
	 * @return UserAgentResolver instance.
	 */
	UserAgentResolver create();

}
