/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request;

/**
 * Abstraction of HTTP request.
 * 
 * <p>
 * This interface is used along the WURFL api. 
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WURFLRequest.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface WURFLRequest {

	/**
	 * Return the user-agent of requester.
	 * 
	 * @return A requester user-agent String
	 */
	String getUserAgent();

	/**
	 * Return the requester UAProf URL.
	 * 
	 * @return The URL of requester UAProf
	 */
	String getUserAgentProfile();

}
