/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request;

import javax.servlet.http.HttpServletRequest;

/**
 * General interface of WURFLRequest Factory
 * <p>
 * To extends WURFLRequest is necessary also extending this interface to build
 * custom {@link WURFLRequest} implementation
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WURFLRequestFactory.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface WURFLRequestFactory {

	/**
	 * Build a {@link WURFLRequest} instance from given request. The
	 * <code>sourceRequest</code> class may change by deploy environment.
	 * 
	 * @param sourceRequest
	 *            A request object from which build custom {@link WURFLRequest}.
	 * @return A instance of {@link WURFLRequest} builded from
	 *         <code>sourceRequest</code>.
	 */
	WURFLRequest createRequest(HttpServletRequest sourceRequest);

	/**
	 * Build WURFLRequest using given User-Agent.
	 * 
	 * @param userAgent
	 *            The user-agent used to build WURFLRequest.
	 * @return Built WURFLRequest.
	 */
	WURFLRequest createRequest(String userAgent);

}
