/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request.normalizer;

/**
 * User-Agent normalizer.
 * 
 * <p>
 * The normalization is responsible to improve chances to match right user-agent
 * by the API. The implementing Object reflect the rules described in <a href="http://www.wurflpro.com/static/contributors_help.htm#gettingmostoutofuseragentstrings"
 * >&quot;Getting the Most out of User-Agent Strings&quot; on wurflpro.com</a>.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: UserAgentNormalizer.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface UserAgentNormalizer {

	/**
	 * Return normalized user-agent.
	 * 
	 * @param userAgent
	 *            String contains user-agent to normalize.
	 * @return String contains normalized user-agent.
	 */
	public String normalize(String userAgent);
}
