/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request.normalizer.generic;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * BlackBerry normalizer.
 * 
 * <p>
 * Strips out the heading "BlackBerry" string.
 * </P>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: BlackBerryNormalizer.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class BlackBerryNormalizer implements UserAgentNormalizer {

	/**
	 * Replaces the heading "BlackBerry" string with "".
	 */
	public String normalize(String userAgent) {

		String normalizedUserAgent = userAgent;

		int index = userAgent.indexOf("BlackBerry");

		if (index != -1 && index > 0) {

			normalizedUserAgent = userAgent.substring(index);

		}
		
		return normalizedUserAgent;
	}

}
