/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request.normalizer.generic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.Validate;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * The UPLink {@link UserAgentNormalizer}.
 * 
 * <p>
 * Strips out the trailing "UP.Link*" from the target user-agent.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: UPLinkNormalizer.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class UPLinkNormalizer implements UserAgentNormalizer {

	/** The regex pattern of trailing "UP.Link" String */
	private static final Pattern UP_LINK_PATTERN = Pattern
			.compile("\\s*UP.Link.+");

    /**
	 * Replace the trailing "UP.Link*" with "".
	 */
	public String normalize(String userAgent) {
		Validate.notNull(userAgent, "The userAgent is null");
		String normalizedUserAgent = userAgent;

		Matcher matcher = UP_LINK_PATTERN.matcher(normalizedUserAgent);

		if (matcher.find()) {
			normalizedUserAgent = matcher.replaceAll("");
		}

		return normalizedUserAgent;
	}

}
