/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request.normalizer.generic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Vodafone {@link UserAgentNormalizer}.
 * 
 * <p>
 * Normalize the "/SNnnnnnnnnnnnnnnnn" String.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: VodafoneNormalizer.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class VodafoneNormalizer implements UserAgentNormalizer {

	private static final Pattern VODAFONE_SN_PATTERN = Pattern.compile("/SN(\\d+)\\s");

    /**
	 * <p>
	 * Replace serial number with X's series.
	 * </p>
	 * <p>
	 * examples:<br/>
	 * /SN12345678 -> /SNXXXXXXXX<br/>
	 * /SN0987654321 -> /SNXXXXXXXXXX
	 * </p>
	 */
	public String normalize(String userAgent) {

		String cleanUA = userAgent;
		Matcher matcher = VODAFONE_SN_PATTERN.matcher(userAgent);

		StrBuilder replace = new StrBuilder();
		if (matcher.find() && matcher.groupCount() == 1) {
			int size = matcher.end(1) - matcher.start(1);
			replace.append("/SN")
				.append(StringUtils.repeat("X", size))
				.append(" ");
			cleanUA = matcher.replaceFirst(replace.toString());
		}

		return cleanUA;
	}

}
