/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request.normalizer.generic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * YesWAP UserAgentNormalizer.
 * 
 * <p>
 * Remove the YesWAP from user-agent.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: YesWAPNormalizer.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class YesWAPNormalizer implements UserAgentNormalizer {

	/** YesWAP regex pattern */
	private static final Pattern YES_WAP_PATTERN = Pattern
			.compile("\\s*Mozilla/4\\.0 \\(YesWAP mobile phone proxy\\)");

    /**
	 * Replace the "YesWAP mobile phone proxy" with "".
	 */
	public String normalize(String userAgent) {

		String normalizedUserAgent = userAgent;

		Matcher matcher = YES_WAP_PATTERN.matcher(userAgent);
		if (matcher.find()) {
			normalizedUserAgent = matcher.replaceAll("");
		}

		return normalizedUserAgent;
	}

}
