/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request.normalizer.specific;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * @author: Fantayeneh Asres Gizaw
 */
public class AndroidNormalizer implements UserAgentNormalizer {

    /**
     * Removes the language
     *
     * @param userAgent String contains user-agent to normalize.
     * @return
     */
    public String normalize(String userAgent) {
        if (StringUtils.contains(userAgent, "Android")) {
            return StringUtils.overlay(userAgent, null, StringUtils.ordinalIndexOf(userAgent, ";", 3), StringUtils.ordinalIndexOf(userAgent, ";", 4));
        }
        return userAgent;
    }
}
