/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request.normalizer.specific;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * This Normalizer returns Chrome with major versio from given user-agent.
 * 
 * @author Tommaso Teofili
 * @author Filippo De Luca
 * 
 * @version $Id: ChromeNormalizer.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class ChromeNormalizer implements UserAgentNormalizer {
	
	/**
	 * Return the Chrome string with the major version  
	 *
	 * @param userAgent
	 * @return String
	 */
	public String normalize(String userAgent) {
		
		String normalized = userAgent;
		
		if(StringUtils.contains(userAgent, "Chrome")) {
			int start = userAgent.indexOf("Chrome");
			normalized = StringUtils.substring(userAgent, start, start + 8);
		}

		return  normalized;
	}

}
